%------------------------------------------------------------------------------
% File     : NUM645^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 7
% Version  : Especial.
% English  : ~(y = pl x y)

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz7 [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 1.00 v3.7.0
% Syntax   : Number of formulae    :   17 (   0 unit;   9 type;   0 defn)
%            Number of atoms       :   57 (   6 equality;  26 variable)
%            Maximal formula depth :    9 (   4 average)
%            Number of connectives :   41 (   4   ~;   0   |;   0   &;  31   @)
%                                         (   0 <=>;   6  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    9 (   9   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   11 (   9   :;   0   =)
%            Number of variables   :   13 (   0 sgn;  13   !;   0   ?;   0   ^)
%                                         (  13   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(nat_type,type,(
    nat: $tType )).

thf(x,type,(
    x: nat )).

thf(y,type,(
    y: nat )).

thf(pl,type,(
    pl: nat > nat > nat )).

thf(set_type,type,(
    set: $tType )).

thf(esti,type,(
    esti: nat > set > $o )).

thf(setof,type,(
    setof: ( nat > $o ) > set )).

thf(estie,axiom,(
    ! [Xp: nat > $o,Xs: nat] :
      ( ( esti @ Xs @ ( setof @ Xp ) )
     => ( Xp @ Xs ) ) )).

thf(n_1,type,(
    n_1: nat )).

thf(suc,type,(
    suc: nat > nat )).

thf(ax5,axiom,(
    ! [Xs: set] :
      ( ( esti @ n_1 @ Xs )
     => ( ! [Xx: nat] :
            ( ( esti @ Xx @ Xs )
           => ( esti @ ( suc @ Xx ) @ Xs ) )
       => ! [Xx: nat] :
            ( esti @ Xx @ Xs ) ) ) )).

thf(estii,axiom,(
    ! [Xp: nat > $o,Xs: nat] :
      ( ( Xp @ Xs )
     => ( esti @ Xs @ ( setof @ Xp ) ) ) )).

thf(ax3,axiom,(
    ! [Xx: nat] :
      ( ( suc @ Xx )
     != n_1 ) )).

thf(satz4a,axiom,(
    ! [Xx: nat] :
      ( ( pl @ Xx @ n_1 )
      = ( suc @ Xx ) ) )).

thf(satz1,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( Xx != Xy )
     => ( ( suc @ Xx )
       != ( suc @ Xy ) ) ) )).

thf(satz4b,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( pl @ Xx @ ( suc @ Xy ) )
      = ( suc @ ( pl @ Xx @ Xy ) ) ) )).

thf(satz7,conjecture,(
    y
 != ( pl @ x @ y ) )).

%------------------------------------------------------------------------------
